using System;  //for console and exception classes
using System.Net; //for IPAddressClass
using System.Net.Sockets; //for Socket class


/// <summary>
/// This is the receiving class stuff lol
/// </summary>
class MCReceive
{
    const int MIN_PORT = 1024;  //the minimum port value
    const int MAX_PORT = 65535; //the maximum port value

    public static int Main(string[] args)
    {
        Socket sock;            //multicast socket
        IPAddress mcIP;         //destination multicast address
        int mcPort;             //destination port
        IPEndPoint ipep;        //IP endpoint
        int MAX_LEN = 1024;       //maximum receive buffer size
        Boolean done = false;     //loop variable

        //verify correct usage
        if (args.Length != 2)
        {
            Console.Error.WriteLine("Usage: MCReceive " + "<Multicast IP> <Multicast Port>");
            return 1;
        }

        //validate the input multicast IP address
        try
        {
            mcIP = IPAddress.Parse(args[0]);
        }
        catch (Exception)
        {
            Console.Error.WriteLine("Invalid IP Address Specified");
            return 1;
        }

        //Validate the input port number
        try
        {
            mcPort = Int32.Parse(args[1]);
        }
        catch (Exception)
        {
            Console.Error.WriteLine("Invalid Port Specified.");
            return 1;
        }

        if ((mcPort < MIN_PORT) || (mcPort > MAX_PORT))
        {
            Console.Error.WriteLine("Invalid Port Specified.");
            Console.Error.WriteLine("Port must be between " + MIN_PORT + " and " + MAX_PORT);
            return 1;
        }

        try
        {
            //create the socket
            sock = new Socket(AddressFamily.InterNetwork, SocketType.Dgram, ProtocolType.Udp);

            //set the reuse address option
            sock.SetSocketOption(SocketOptionLevel.Socket, SocketOptionName.ReuseAddress, 1);

            //create an IPEndPoint and bind to it
            IPEndPoint ipep = new IPEndPoint(IPAddress.Any, mcPort);
            sock.Bind(ipep);

            //add membership in the multicast group
            sock.SetSocketOption(SocketOptionLevel.IP, SocketOptionName.AddMembership,
                                    new MulticastOption(mcIP, IPAddress.Any));

            //create the endpoint class
            receivePoint = new IPEndPoint(IPAddress.Any, 0);
            EndPoint tempReceivePoint = (EndPoint)receivePoint;

            while (!done)
            {
                byte[] recData = new byte[MAX_LEN];

                //receive the multicast packets
                int length = sock.ReceiveFrom(recData, 0, MAX_LEN, SocketFlags.None,
                                                ref tempReceivePoint);

                //format and output the received data packet
                System.Text.ASCIIEncoding encode = new System.Text.ASCIIEncoding();
                Console.WriteLine("Received " + length + " bytes from " + tempReceivePoint.ToString() + ": " +
                                        encode.GetString(recData, 0, length));
            }

            //drop membership
            sock.SetSocketOption(SocketOptionLevel.IP, SocketOptionName.DropMembership,
                                    new MulticastOption(mcIP, IPAddress.Any));

            //close the socket
            sock.Close();
        }

    //basic error handling
        catch (SocketException se)
        {
            Console.Error.WriteLine("Socket Exception: " + se.ToString());
            return 1;
        }
        catch (Exception e)
        {
            Console.Error.WriteLine("Exception: " + e.ToString());
            return 1;
        }
        return 0;
    }
}
